/*
 * Decompiled with CFR 0.152.
 */
package com.sun.lwuit.html;

import com.sun.lwuit.Component;
import com.sun.lwuit.html.DocumentInfo;
import com.sun.lwuit.html.HTMLComponent;
import com.sun.lwuit.html.ResourceThread;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

class ResourceThreadQueue {
    private static int DEFAULT_MAX_THREADS;
    HTMLComponent htmlC;
    Vector queue = new Vector();
    Vector running = new Vector();
    Vector bgImageCompsUnselected = new Vector();
    Vector bgImageCompsSelected = new Vector();
    Vector bgImageCompsPressed = new Vector();
    Hashtable images = new Hashtable();
    static int maxThreads;
    int threadCount;
    private int cssCount = -1;
    boolean started;

    ResourceThreadQueue(HTMLComponent htmlC) {
        this.htmlC = htmlC;
    }

    static void setMaxThreads(int threadsNum) {
        maxThreads = threadsNum;
    }

    synchronized void add(Component imgLabel, String imageUrl) {
        if (this.started) {
            throw new IllegalStateException("ResourceThreadQueue alreadey started! stop/cancel first");
        }
        this.images.put(imgLabel, imageUrl);
    }

    synchronized void addBgImage(Component imgComp, String imageUrl, int styles) {
        this.add(imgComp, imageUrl);
        if ((styles & 2) != 0) {
            this.bgImageCompsSelected.addElement(imgComp);
        }
        if ((styles & 1) != 0) {
            this.bgImageCompsUnselected.addElement(imgComp);
        }
        if ((styles & 4) != 0) {
            this.bgImageCompsPressed.addElement(imgComp);
        }
    }

    synchronized void addCSS(String cssUrl, String encoding) {
        if (this.started) {
            throw new IllegalStateException("ResourceThreadQueue alreadey started! stop/cancel first");
        }
        DocumentInfo cssDocInfo = new DocumentInfo(cssUrl, DocumentInfo.TYPE_CSS);
        if (encoding != null) {
            cssDocInfo.setEncoding(encoding);
        }
        ResourceThread t = new ResourceThread(cssDocInfo, this.htmlC, this);
        this.queue.addElement(t);
        this.incCSSCount();
    }

    private void incCSSCount() {
        if (this.cssCount == -1) {
            ++this.cssCount;
        }
        ++this.cssCount;
    }

    synchronized int getCSSCount() {
        return this.cssCount;
    }

    int getQueueSize() {
        return this.images.size() + this.queue.size();
    }

    synchronized void startRunning() {
        if (!this.startDequeue()) {
            this.startRunningImages();
        }
    }

    synchronized void startRunningImages() {
        this.queue.removeAllElements();
        Vector<String> urls = new Vector<String>();
        Enumeration e = this.images.keys();
        while (e.hasMoreElements()) {
            ResourceThread t;
            Component imgComp = (Component)e.nextElement();
            String imageUrl = (String)this.images.get(imgComp);
            int urlIndex = urls.indexOf(imageUrl);
            if (urlIndex != -1) {
                t = (ResourceThread)this.queue.elementAt(urlIndex);
                t.addLabel(imgComp);
                continue;
            }
            t = new ResourceThread(imageUrl, imgComp, this.htmlC, this);
            this.queue.addElement(t);
            urls.addElement(imageUrl);
        }
        urls = null;
        this.images = new Hashtable();
        if (!this.startDequeue()) {
            this.htmlC.setPageStatus(4);
        }
    }

    private synchronized boolean startDequeue() {
        int threads = Math.min(this.queue.size(), maxThreads);
        for (int i = 0; i < threads; ++i) {
            ResourceThread t = (ResourceThread)this.queue.firstElement();
            this.queue.removeElementAt(0);
            this.running.addElement(t);
            ++this.threadCount;
            new Thread(t).start();
        }
        return threads > 0;
    }

    synchronized void threadFinished(ResourceThread finishedThread, boolean success) {
        if (finishedThread.cssDocInfo != null) {
            --this.cssCount;
        }
        if (this.cssCount == 0) {
            this.cssCount = -1;
            this.htmlC.applyAllCSS();
            this.htmlC.cssCompleted();
        }
        this.running.removeElement(finishedThread);
        if (this.queue.size() > 0) {
            ResourceThread t = (ResourceThread)this.queue.firstElement();
            this.queue.removeElementAt(0);
            this.running.addElement(t);
            new Thread(t).start();
        } else {
            --this.threadCount;
        }
        if (this.threadCount == 0) {
            if (this.images.size() == 0) {
                this.htmlC.setPageStatus(4);
            } else {
                this.startRunningImages();
            }
        }
    }

    synchronized void discardQueue() {
        this.queue.removeAllElements();
        Enumeration e = this.running.elements();
        while (e.hasMoreElements()) {
            ResourceThread t = (ResourceThread)e.nextElement();
            t.cancel();
        }
        this.running.removeAllElements();
        this.bgImageCompsSelected.removeAllElements();
        this.bgImageCompsUnselected.removeAllElements();
        this.bgImageCompsPressed.removeAllElements();
        this.threadCount = 0;
        this.cssCount = -1;
        this.started = false;
    }

    public String toString() {
        ResourceThread t;
        String str = "---- Running ----\n";
        int i = 1;
        Enumeration e = this.running.elements();
        while (e.hasMoreElements()) {
            t = (ResourceThread)e.nextElement();
            str = t.imageUrl != null ? str + "#" + i + ": " + t.imageUrl + "\n" : str + "#" + i + ": CSS - " + t.cssDocInfo.getUrl() + "\n";
            ++i;
        }
        i = 1;
        str = str + "Queue:\n";
        e = this.queue.elements();
        while (e.hasMoreElements()) {
            t = (ResourceThread)e.nextElement();
            str = t.imageUrl != null ? str + "#" + i + ": " + t.imageUrl + "\n" : str + "#" + i + ": CSS - " + t.cssDocInfo.getUrl() + "\n";
            ++i;
        }
        str = str + "---- count:" + this.threadCount + " ----\n";
        return str;
    }

    static {
        maxThreads = DEFAULT_MAX_THREADS = 2;
    }
}

