/*
 * Decompiled with CFR 0.152.
 */
package com.sun.lwuit.html;

import com.sun.lwuit.Component;
import com.sun.lwuit.events.DataChangedListener;
import com.sun.lwuit.html.CellConstraint;
import com.sun.lwuit.table.TableModel;
import com.sun.lwuit.util.EventDispatcher;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

class HTMLTableModel
implements TableModel {
    Vector rows = new Vector();
    Vector headers = new Vector();
    int maxColumn;
    Vector currentRow = new Vector();
    Hashtable constraints = new Hashtable();
    private EventDispatcher dispatcher = new EventDispatcher();

    HTMLTableModel() {
    }

    void addCell(Component cell, boolean isHeader, CellConstraint constraint) {
        if (isHeader) {
            this.headers.addElement(cell);
        }
        this.currentRow.addElement(cell);
        if (this.currentRow.size() > this.maxColumn) {
            this.maxColumn = this.currentRow.size();
        }
        if (constraint != null) {
            this.constraints.put(cell, constraint);
        }
    }

    void setAlignToAll(boolean isHorizontal, int align) {
        Enumeration e = this.constraints.elements();
        while (e.hasMoreElements()) {
            CellConstraint cc = (CellConstraint)e.nextElement();
            if (isHorizontal) {
                cc.setHorizontalAlign(align);
                continue;
            }
            cc.setVerticalAlign(align);
        }
    }

    CellConstraint getConstraint(Object object) {
        return (CellConstraint)this.constraints.get(object);
    }

    boolean isHeader(Object object) {
        return this.headers.contains(object);
    }

    void commitRow() {
        this.rows.addElement(this.currentRow);
        this.currentRow = new Vector();
    }

    void commitRowIfNotEmpty() {
        if (this.currentRow.size() > 0) {
            this.commitRow();
        }
    }

    public int getRowCount() {
        return this.rows.size();
    }

    public int getColumnCount() {
        return this.maxColumn;
    }

    public String getColumnName(int i) {
        return "";
    }

    public boolean isCellEditable(int row, int column) {
        return false;
    }

    public Object getValueAt(int row, int column) {
        if (row >= this.rows.size()) {
            return "";
        }
        Vector columns = (Vector)this.rows.elementAt(row);
        if (column >= columns.size()) {
            return "";
        }
        return columns.elementAt(column);
    }

    public void setValueAt(int row, int column, Object o) {
        Vector columns = (Vector)this.rows.elementAt(row);
        columns.removeElementAt(column);
        columns.setElementAt(o, column);
        this.dispatcher.fireDataChangeEvent(column, row);
    }

    public void addDataChangeListener(DataChangedListener d) {
        this.dispatcher.addListener(d);
    }

    public void removeDataChangeListener(DataChangedListener d) {
        this.dispatcher.removeListener(d);
    }
}

