/*
 * Decompiled with CFR 0.152.
 */
package com.sun.lwuit.html;

import com.sun.lwuit.Component;
import com.sun.lwuit.html.Element;
import com.sun.lwuit.html.Parser;
import java.util.Enumeration;

class CSSElement
extends Element {
    private static final int DPI = 72;
    private static final String[] CSS_LENGTH_SUFFIX = new String[]{"px", "em", "ex", "in", "pt", "pc", "mm", "cm"};
    private static final String CENTER_STR = "center";
    private static final String CSS_NONE = "none";
    static final String SMALL_CAPS_STRING = "small-caps";
    static final String[] BG_REPEAT_STRINGS = new String[]{"repeat", "repeat-x", "repeat-y", "no-repeat"};
    private static final int[] BG_REPEAT_VALS = new int[]{2, 4, 3, 0};
    private static final String[] TEXT_ALIGN_STRINGS = new String[]{"left", "right", "center"};
    private static final int[] TEXT_ALIGN_VALS = new int[]{1, 3, 4};
    private static final String[] VERTICAL_ALIGN_STRINGS = new String[]{"top", "middle", "bottom", "baseline", "sub", "super"};
    private static final int[] VERTICAL_ALIGN_VALS = new int[]{0, 4, 2, -1, -1, -1};
    private static final String[] BORDER_STYLE_STRINGS = new String[]{"none", "solid", "groove", "ridge", "inset", "outset", "dotted", "dashed", "double"};
    private static final String[] BORDER_WIDTH_STRINGS = new String[]{"thin", "medium", "thick"};
    private static final int[] BORDER_WIDTH_VALS = new int[]{1, 3, 5};
    static final int BORDER_DEFAULT_WIDTH = BORDER_WIDTH_VALS[1];
    static final int FONT_SIZE_SMALLER = -3;
    static final int FONT_SIZE_LARGER = -2;
    static final int FONT_SIZE_SMALL = 12;
    static final int FONT_SIZE_MEDIUM = 15;
    static final int FONT_SIZE_LARGE = 19;
    private static final String[] FONT_SIZE_STRINGS = new String[]{"xx-small", "x-small", "small", "medium", "large", "x-large", "xx-large", "smaller", "larger"};
    private static final int[] FONT_SIZE_VALS = new int[]{8, 10, 12, 15, 19, 21, 23, -3, -2};
    private static final String[] FONT_STYLE_STRINGS = new String[]{"normal", "italic", "oblique"};
    private static final int[] FONT_STYLE_VALS = new int[]{0, 2, 2};
    private static final String[] FONT_WEIGHT_STRINGS = new String[]{"normal", "bold", "bolder", "lighter", "100", "200", "300", "400", "500", "600", "700", "800", "900"};
    private static final int[] FONT_WEIGHT_VALS = new int[]{0, 1, 1, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1};
    static final int CSS_STYLE_ID_OFFSET = 500;
    static final int CSS_BACKGROUND_COLOR = 500;
    static final int CSS_BACKGROUND_IMAGE = 501;
    static final int CSS_BACKGROUND_REPEAT = 502;
    static final int CSS_BACKGROUND_ATTACHMENT = 503;
    static final int CSS_BACKGROUND_POSITION_X = 504;
    static final int CSS_BACKGROUND_POSITION_Y = 505;
    static final int CSS_BORDER_TOP_WIDTH = 506;
    static final int CSS_BORDER_LEFT_WIDTH = 507;
    static final int CSS_BORDER_BOTTOM_WIDTH = 508;
    static final int CSS_BORDER_RIGHT_WIDTH = 509;
    static final int CSS_BORDER_TOP_STYLE = 510;
    static final int CSS_BORDER_LEFT_STYLE = 511;
    static final int CSS_BORDER_BOTTOM_STYLE = 512;
    static final int CSS_BORDER_RIGHT_STYLE = 513;
    static final int CSS_BORDER_TOP_COLOR = 514;
    static final int CSS_BORDER_LEFT_COLOR = 515;
    static final int CSS_BORDER_BOTTOM_COLOR = 516;
    static final int CSS_BORDER_RIGHT_COLOR = 517;
    static final int CSS_CLEAR = 518;
    static final int CSS_COLOR = 519;
    static final int CSS_VERTICAL_ALIGN = 520;
    static final int CSS_DISPLAY = 521;
    static final int CSS_FLOAT = 522;
    static final int CSS_FONT_FAMILY = 523;
    static final int CSS_FONT_SIZE = 524;
    static final int CSS_FONT_STYLE = 525;
    static final int CSS_FONT_WEIGHT = 526;
    static final int CSS_FONT_VARIANT = 527;
    static final int CSS_HEIGHT = 528;
    static final int CSS_WIDTH = 529;
    static final int CSS_VISIBILITY = 530;
    static final int CSS_WHITE_SPACE = 531;
    static final int CSS_LIST_STYLE_IMAGE = 532;
    static final int CSS_LIST_STYLE_POSITION = 533;
    static final int CSS_LIST_STYLE_TYPE = 534;
    static final int CSS_MARGIN_TOP = 535;
    static final int CSS_MARGIN_LEFT = 536;
    static final int CSS_MARGIN_BOTTOM = 537;
    static final int CSS_MARGIN_RIGHT = 538;
    static final int CSS_PADDING_TOP = 539;
    static final int CSS_PADDING_LEFT = 540;
    static final int CSS_PADDING_BOTTOM = 541;
    static final int CSS_PADDING_RIGHT = 542;
    static final int CSS_TEXT_ALIGN = 543;
    static final int CSS_TEXT_DECORATION = 544;
    static final int CSS_TEXT_INDENT = 545;
    static final int CSS_TEXT_TRANSFORM = 546;
    static final int CSS_WAP_ACCESSKEY = 547;
    static final int CSS_WAP_INPUT_FORMAT = 548;
    static final int CSS_WAP_INPUT_REQUIRED = 549;
    static final int CSS_PAGEURL = 550;
    static final int[] CSS_ATTRIBUTE_TYPES = new int[]{2, 26, 7, 7, 25, 25, 24, 24, 24, 24, 7, 7, 7, 7, 2, 2, 2, 2, 7, 2, 7, 7, 7, 7, 25, 7, 7, 7, 25, 25, 7, 7, 26, 7, 7, 25, 25, 25, 25, 25, 25, 25, 25, 3, 7, 25, 7, 7, 7, 13, 7};
    private String[][] CSS_ALLOWED_STRINGS = new String[][]{null, null, BG_REPEAT_STRINGS, {"fixed", "scroll"}, {"left", "center", "right"}, {"top", "center", "bottom"}, BORDER_WIDTH_STRINGS, BORDER_WIDTH_STRINGS, BORDER_WIDTH_STRINGS, BORDER_WIDTH_STRINGS, BORDER_STYLE_STRINGS, BORDER_STYLE_STRINGS, BORDER_STYLE_STRINGS, BORDER_STYLE_STRINGS, null, null, null, null, {"left", "right", "none", "both"}, null, VERTICAL_ALIGN_STRINGS, {"inline", "block", "list-item", "none", "-wap-marquee"}, {"left", "right", "none"}, null, FONT_SIZE_STRINGS, FONT_STYLE_STRINGS, FONT_WEIGHT_STRINGS, {"normal", "small-caps"}, null, null, {"hidden", "visible"}, {"normal", "pre", "nowrap"}, null, {"inside", "outside"}, {"none", "disc", "circle", "square", "decimal", "upper-alpha", "lower-alpha", "upper-roman", "lower-roman"}, null, null, null, null, null, null, null, null, TEXT_ALIGN_STRINGS, {"none"}, null, {"none", "uppercase", "lowercase", "capitalize"}, null, null, {"true", "false"}, null};
    private final int[][] CSS_ALLOWED_STRINGS_VALS = new int[][]{null, null, BG_REPEAT_VALS, null, BG_POS_PERCENTAGE, BG_POS_PERCENTAGE, BORDER_WIDTH_VALS, BORDER_WIDTH_VALS, BORDER_WIDTH_VALS, BORDER_WIDTH_VALS, null, null, null, null, null, null, null, null, null, null, VERTICAL_ALIGN_VALS, null, null, null, FONT_SIZE_VALS, FONT_STYLE_VALS, FONT_WEIGHT_VALS, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, TEXT_ALIGN_VALS, null, null, null, null, null, null, null};
    int[] attrVals = new int[CSS_ATTRIBUTE_ROOTS.length];
    static final int VAL_PERCENTAGE = 0x100000;
    static final int VAL_EX = 0x200000;
    private static final int[] BG_POS_PERCENTAGE = new int[]{0x100000, 1048626, 1048676};
    static final String[] CSS_ATTRIBUTE_ROOTS = new String[]{"background-color", "background-image", "background-repeat", "background-attachment", "background-position-x", "background-position-y", "border-top-width", "border-left-width", "border-bottom-width", "border-right-width", "border-top-style", "border-left-style", "border-bottom-style", "border-right-style", "border-top-color", "border-left-color", "border-bottom-color", "border-right-color", "clear", "color", "vertical-align", "display", "float", "font-family", "font-size", "font-style", "font-weight", "font-variant", "height", "width", "visibility", "white-space", "list-style-image", "list-style-position", "list-style-type", "margin-top", "margin-left", "margin-bottom", "margin-right", "padding-top", "padding-left", "padding-bottom", "padding-right", "text-align", "text-decoration", "text-indent", "text-transform", "-wap-access-key", "-wap-input-format", "-wap-input-required", "pageurl"};
    static final String[] CSS_SHORTHAND_ATTRIBUTE_LIST = new String[]{"background", "background-position", "border-width", "border-style", "border-color", "border-top", "border-right", "border-bottom", "border-left", "border", "font", "margin", "padding", "list-style"};
    static final boolean[] CSS_IS_SHORTHAND_ATTRIBUTE_COLLATABLE = new boolean[]{false, false, true, true, true, false, false, false, false, false, false, true, true, false};
    private static final int CSS_TOP = 0;
    private static final int CSS_RIGHT = 1;
    private static final int CSS_BOTTOM = 2;
    private static final int CSS_LEFT = 3;
    static final int[][][] CSS_COLLATABLE_ORDER = new int[][][]{new int[][]{{0, 1, 2, 3}}, new int[][]{{0, 2}, {3, 1}}, new int[][]{{0}, {3, 1}, {2}}, new int[][]{{0}, {1}, {2}, {3}}};
    private static final int CSS_SHORTHAND_BACKGROUND_POSITION = 1;
    private static final int CSS_SHORTHAND_BORDER_WIDTH = 2;
    private static final int CSS_SHORTHAND_BORDER_STYLE = 3;
    private static final int CSS_SHORTHAND_BORDER_COLOR = 4;
    static final int[][] CSS_SHORTHAND_ATTRIBUTE_INDEX = new int[][]{{500, 501, 502, 503, 1}, {504, 505}, {506, 509, 508, 507}, {510, 513, 512, 511}, {514, 517, 516, 515}, {506, 510, 514}, {509, 513, 517}, {508, 512, 516}, {507, 511, 515}, {2, 3, 4}, {525, 527, 526, 524, 523}, {535, 538, 537, 536}, {539, 542, 541, 540}, {534, 533, 532}};
    private int selectorSpecificity = -1;
    private String selectorId = null;
    private String selectorClass = null;
    private String selectorTag = null;
    private int selectorPseudoClass = 0;
    static final int PC_FOCUS = 1;
    static final int PC_ACTIVE = 2;
    static final int PC_LINK = 4;
    static final int PC_VISITED = 8;
    static final String[] PSEUDO_CLASSES_STRINGS = new String[]{"hover", "focus", "active", "link", "visited"};
    static final int[] PSEUDO_CLASSES_VALS = new int[]{1, 1, 2, 4, 8};

    static int convertUnitsOrPercentage(String units) {
        if (units == null) {
            return -1;
        }
        boolean percentage = false;
        if (units.charAt(units.length() - 1) == '%') {
            percentage = true;
            units = units.substring(0, units.length() - 1);
        }
        int val = CSSElement.convertUnits(units);
        if (percentage) {
            val += 0x100000;
        }
        return val;
    }

    static int convertUnits(String units) {
        int i;
        if (units == null) {
            return -1;
        }
        int factor = 1;
        int[] factors = new int[]{1, 2, 1, 72, 1, 12, 2, 28};
        for (i = 0; i < CSS_LENGTH_SUFFIX.length; ++i) {
            if (!units.endsWith(CSS_LENGTH_SUFFIX[i])) continue;
            factor = factors[i];
            units = units.substring(0, units.length() - 2);
            break;
        }
        try {
            int result = (int)(Float.parseFloat(units) * (float)factor);
            if (i == 1 || i == 2) {
                result += 0x200000;
            }
            return result;
        }
        catch (NumberFormatException nfe) {
            return -1;
        }
    }

    CSSElement(String name) {
        this.id = -2;
        this.name = name;
        for (int i = 0; i < CSS_ATTRIBUTE_ROOTS.length; ++i) {
            this.attrVals[i] = -1;
        }
    }

    String getName() {
        return this.name;
    }

    boolean isAttributeAssigned(int attrId) {
        return this.attrVals[attrId - 500] != -1 || this.attributes.get(new Integer(attrId)) != null;
    }

    CSSElement getCSSChildAt(int index) {
        if (index < 0 || index >= this.children.size()) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return (CSSElement)this.children.elementAt(index);
    }

    int addAttribute(String attribute, String value) {
        int attrId = -1;
        for (int i = 0; attrId == -1 && i < CSS_ATTRIBUTE_ROOTS.length; ++i) {
            if (!CSS_ATTRIBUTE_ROOTS[i].equals(attribute)) continue;
            attrId = 500 + i;
            break;
        }
        if (attrId == -1) {
            return 11;
        }
        return this.addAttribute(attrId, value);
    }

    int addAttribute(int attrId, String value) {
        int i = attrId - 500;
        boolean knownType = true;
        int val = -1;
        switch (CSS_ATTRIBUTE_TYPES[i]) {
            case 2: {
                val = CSSElement.getColor(value, -1);
                break;
            }
            case 24: {
                val = CSSElement.convertUnits(value);
                break;
            }
            case 25: {
                val = CSSElement.convertUnitsOrPercentage(value);
                break;
            }
            default: {
                knownType = false;
            }
        }
        if (val == -1) {
            if (this.CSS_ALLOWED_STRINGS[i] != null) {
                val = Parser.getStringVal(value, this.CSS_ALLOWED_STRINGS[i], this.CSS_ALLOWED_STRINGS_VALS[i]);
                if (val == -1) {
                    return 2;
                }
                this.attrVals[i] = val;
                this.fixBackgroundPositionDefaults(attrId);
            } else {
                if (knownType) {
                    return 2;
                }
                this.attributes.put(new Integer(attrId), value);
            }
        } else {
            this.attrVals[i] = val;
            this.fixBackgroundPositionDefaults(attrId);
        }
        return -1;
    }

    private void fixBackgroundPositionDefaults(int attrId) {
        if (attrId == 504 && !this.isAttributeAssigned(505)) {
            this.addAttribute(505, CENTER_STR);
        } else if (attrId == 505 && !this.isAttributeAssigned(504)) {
            this.addAttribute(504, CENTER_STR);
        }
    }

    String getAttributeName(Integer attrKey) {
        return CSS_ATTRIBUTE_ROOTS[attrKey - 500];
    }

    int getSelectorSpecificity() {
        if (this.selectorSpecificity == -1) {
            this.selectorSpecificity = this.calcSelectorSpecificity();
        }
        return this.selectorSpecificity;
    }

    int getAttrVal(int attrId) {
        return this.attrVals[attrId - 500];
    }

    int getAttrLengthVal(int attrId, Component cmp, int origDimension) {
        int val = this.getAttrVal(attrId);
        if (val >= 0) {
            if ((val & 0x100000) != 0) {
                val -= 0x100000;
                val = val * origDimension / 100;
            } else if ((val & 0x200000) != 0) {
                val -= 0x200000;
                val = val * cmp.getStyle().getFont().getHeight() / 2;
            }
        }
        return val;
    }

    int calcSelectorSpecificity() {
        int spec = 0;
        String nameStr = this.name;
        if (nameStr.startsWith("*")) {
            nameStr = nameStr.substring(1);
        }
        int index = nameStr.lastIndexOf(58);
        while (index != -1) {
            String property = nameStr.substring(index + 1);
            nameStr = nameStr.substring(0, index);
            int propNum = Parser.getStringVal(property, PSEUDO_CLASSES_STRINGS, PSEUDO_CLASSES_VALS);
            if (propNum != -1) {
                this.selectorPseudoClass += propNum;
                ++spec;
            }
            index = nameStr.lastIndexOf(58);
        }
        if (this.selectorPseudoClass != 0 && nameStr.equals("")) {
            nameStr = "a";
        }
        this.name = nameStr;
        index = nameStr.indexOf(35);
        if (index != -1) {
            spec += 100;
            this.selectorId = this.name.substring(index + 1);
            if (index != 0) {
                ++spec;
                this.selectorTag = this.name.substring(0, index);
            }
        } else {
            index = nameStr.indexOf(46);
            if (index != -1) {
                spec += 10;
                this.selectorClass = this.name.substring(index + 1);
                if (index != 0) {
                    ++spec;
                    this.selectorTag = this.name.substring(0, index);
                }
            } else if (nameStr.length() > 0) {
                ++spec;
                this.selectorTag = this.name;
            }
        }
        for (int i = 0; i < this.getNumChildren(); ++i) {
            spec += this.getCSSChildAt(i).getSelectorSpecificity();
        }
        return spec;
    }

    String getSelectorId() {
        return this.selectorId;
    }

    String getSelectorClass() {
        return this.selectorClass;
    }

    String getSelectorTag() {
        return this.selectorTag;
    }

    int getSelectorPseudoClass() {
        return this.selectorPseudoClass;
    }

    void copyAttributesTo(CSSElement dest) {
        for (int i = 0; i < this.attrVals.length; ++i) {
            dest.attrVals[i] = this.attrVals[i];
        }
        Enumeration e = this.attributes.keys();
        while (e.hasMoreElements()) {
            Integer key = (Integer)e.nextElement();
            String value = (String)this.attributes.get(key);
            dest.attributes.put(key, value);
        }
    }
}

