/*
 * Decompiled with CFR 0.152.
 */
package com.sun.lwuit;

import com.sun.lwuit.Component;
import com.sun.lwuit.Display;
import com.sun.lwuit.Font;
import com.sun.lwuit.Graphics;
import com.sun.lwuit.events.ActionEvent;
import com.sun.lwuit.events.ActionListener;
import com.sun.lwuit.geom.Dimension;
import com.sun.lwuit.geom.Rectangle;
import com.sun.lwuit.plaf.LookAndFeel;
import com.sun.lwuit.plaf.Style;
import com.sun.lwuit.plaf.UIManager;
import java.util.Vector;

public class TextArea
extends Component {
    private static int defaultMaxSize = 124;
    private static boolean autoDegradeMaxSize = false;
    private static boolean hadSuccessfulEdit = false;
    private int linesToScroll = 1;
    private static final char ENTER_KEY = '\n';
    private String unsupportedChars = "\t\r";
    private static boolean useStringWidth;
    public static final int ANY = 0;
    public static final int EMAILADDR = 1;
    public static final int NUMERIC = 2;
    public static final int PHONENUMBER = 3;
    public static final int URL = 4;
    public static final int DECIMAL = 5;
    public static final int PASSWORD = 65536;
    public static final int UNEDITABLE = 131072;
    public static final int SENSITIVE = 262144;
    public static final int NON_PREDICTIVE = 524288;
    public static final int INITIAL_CAPS_WORD = 0x100000;
    public static final int INITIAL_CAPS_SENTENCE = 0x200000;
    private int constraint = 0;
    private String text = "";
    private boolean editable = true;
    private int maxSize = defaultMaxSize;
    private int rows = 1;
    private int columns = 3;
    private Vector rowStrings;
    private int widthForRowCalculations = -1;
    private int rowsGap = 2;
    private boolean triggerClose;
    private Vector actionListeners = null;
    private boolean growByContent = true;
    private static char widestChar;
    private boolean singleLineTextArea;
    private int align = 1;
    private int absAlign = this.isRTL() ? 3 : 1;
    private int currentRowWidth;

    public TextArea(int rows, int columns) {
        this("", defaultMaxSize, rows, columns, 0);
    }

    public TextArea(int rows, int columns, int constraint) {
        this("", defaultMaxSize, rows, columns, constraint);
    }

    public TextArea(String text, int rows, int columns) {
        this(text, defaultMaxSize, rows, columns, 0);
    }

    public TextArea(String text, int rows, int columns, int constraint) {
        this(text, defaultMaxSize, rows, columns, constraint);
    }

    public TextArea(String text, int maxSize) {
        this(text, maxSize, 1, 3, 0);
    }

    public TextArea(String text) {
        this(text, Math.max(defaultMaxSize, text.length()), 1, 3, 0);
    }

    public TextArea() {
        this("");
    }

    private TextArea(String text, int maxSize, int rows, int columns, int constraint) {
        this.setUIID("TextArea");
        this.setSelectCommandText(UIManager.getInstance().localize("edit", "Edit"));
        this.maxSize = maxSize;
        this.setText(text);
        this.setConstraint(constraint);
        if (rows <= 0) {
            throw new IllegalArgumentException("rows must be positive");
        }
        if (columns <= 1 && rows != 1) {
            throw new IllegalArgumentException("columns must be larger than 1");
        }
        this.rows = rows;
        this.columns = columns;
        LookAndFeel laf = UIManager.getInstance().getLookAndFeel();
        this.setSmoothScrolling(laf.isDefaultSmoothScrolling());
    }

    public void setConstraint(int constraint) {
        this.constraint = constraint;
    }

    public int getConstraint() {
        return this.constraint;
    }

    public void setWidth(int width) {
        super.setWidth(width);
        this.getRowStrings();
    }

    public void setText(String t) {
        this.text = t != null ? t : "";
        this.setShouldCalcPreferredSize(true);
        if (this.maxSize < this.text.length()) {
            this.maxSize = this.text.length() + 1;
        }
        this.rowStrings = null;
        this.repaint();
    }

    public String getText() {
        return this.text;
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setEditable(boolean b) {
        this.editable = b;
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public void setMaxSize(int maxSize) {
        this.maxSize = maxSize;
    }

    public void keyPressed(int keyCode) {
        super.keyPressed(keyCode);
        int action = Display.getInstance().getGameAction(keyCode);
        this.triggerClose = action == 8;
        Rectangle rect = new Rectangle(this.getScrollX(), this.getScrollY(), this.getWidth(), this.getHeight());
        Font textFont = this.getStyle().getFont();
        if (action == 6) {
            if (this.getScrollY() + this.getHeight() < (this.rowsGap + this.getStyle().getFont().getHeight()) * this.getLines()) {
                rect.setY(rect.getY() + (textFont.getHeight() + this.rowsGap) * this.linesToScroll);
                this.scrollRectToVisible(rect, this);
            } else {
                this.setHandlesInput(false);
            }
        } else if (action == 1) {
            if (this.getScrollY() > 0) {
                rect.setY(Math.max(0, rect.getY() - (textFont.getHeight() + this.rowsGap) * this.linesToScroll));
                this.scrollRectToVisible(rect, this);
            } else {
                this.setHandlesInput(false);
            }
        }
        if (action == 5 || action == 2) {
            this.setHandlesInput(false);
        }
    }

    protected void fireClicked() {
        this.onClick();
    }

    protected boolean isSelectableInteraction() {
        return this.editable;
    }

    public void keyReleased(int keyCode) {
        int action = Display.getInstance().getGameAction(keyCode);
        if (this.isEditable() && this.triggerClose && (action == 8 || this.isEnterKey(keyCode))) {
            this.triggerClose = false;
            this.onClick();
            return;
        }
    }

    public boolean isScrollableY() {
        return this.isFocusable() && this.getScrollDimension().getHeight() > this.getHeight();
    }

    void onClick() {
        if (this.isEditable()) {
            this.editString();
        }
    }

    void editString() {
        if (autoDegradeMaxSize && !hadSuccessfulEdit && this.maxSize > 1024) {
            try {
                Display.getInstance().editString(this, this.getMaxSize(), this.getConstraint(), this.getText());
            }
            catch (IllegalArgumentException err) {
                this.maxSize -= 1024;
                TextArea.setDefaultMaxSize(this.maxSize);
                this.editString();
            }
        } else {
            Display.getInstance().editString(this, this.getMaxSize(), this.getConstraint(), this.getText());
        }
    }

    public void pointerHover(int[] x, int[] y) {
        this.requestFocus();
    }

    public void pointerHoverReleased(int[] x, int[] y) {
        this.requestFocus();
    }

    public void pointerReleased(int x, int y) {
        if (this.isDragActivated()) {
            super.pointerReleased(x, y);
        } else {
            super.pointerReleased(x, y);
            if (this.isEditable()) {
                this.onClick();
            }
        }
    }

    void focusGainedInternal() {
        super.focusGainedInternal();
        this.setHandlesInput(this.isScrollableY());
    }

    void focusLostInternal() {
        super.focusLostInternal();
        this.setHandlesInput(false);
    }

    public int getColumns() {
        return this.columns;
    }

    public int getActualRows() {
        if (this.growByContent) {
            return Math.max(this.rows, this.getLines());
        }
        return this.rows;
    }

    public int getRows() {
        return this.rows;
    }

    public void setColumns(int columns) {
        this.setShouldCalcPreferredSize(true);
        this.columns = columns;
    }

    public void setRows(int rows) {
        this.setShouldCalcPreferredSize(true);
        this.rows = rows;
    }

    void initComponentImpl() {
        this.getRowStrings();
        super.initComponentImpl();
    }

    private Vector getRowStrings() {
        if (this.rowStrings == null || this.widthForRowCalculations != this.getWidth() - this.getUnselectedStyle().getPadding(false, 3) - this.getUnselectedStyle().getPadding(false, 1)) {
            this.initRowString();
            this.setShouldCalcPreferredSize(true);
        }
        return this.rowStrings;
    }

    public int getLines() {
        Vector v = this.getRowStrings();
        int retVal = v.size();
        return retVal;
    }

    public String getTextAt(int line) {
        Vector rowsV = this.getRowStrings();
        if (rowsV.size() == 0) {
            return "";
        }
        return (String)rowsV.elementAt(line);
    }

    private int indexOf(char[] t, char c, int offset, int length) {
        for (int iter = offset; iter < t.length && iter < offset + length; ++iter) {
            if (t[iter] != c) continue;
            return iter;
        }
        return -1;
    }

    protected char[] preprocess(String text) {
        return text.toCharArray();
    }

    private int updateRowWidth(char c, Font font) {
        this.currentRowWidth += font.charWidth(c);
        return this.currentRowWidth;
    }

    private boolean fastCharWidthCheck(char[] chrs, int off, int length, int width, int charWidth, Font f) {
        if (length * charWidth < width) {
            return true;
        }
        return f.charsWidth(chrs, off, length = Math.min(chrs.length, length)) < width;
    }

    private void initRowString() {
        int cw;
        Style style = this.getUnselectedStyle();
        this.rowStrings = new Vector();
        this.widthForRowCalculations = this.getWidth() - style.getPadding(false, 3) - style.getPadding(false, 1);
        if (this.isSingleLineTextArea() || this.widthForRowCalculations <= 0) {
            this.rowStrings.addElement(this.getText());
            return;
        }
        if (this.text == null || this.text.equals("")) {
            return;
        }
        char[] text = this.preprocess(this.getText());
        int rows = this.rows;
        if (this.growByContent) {
            rows = Math.max(rows, this.getLines());
        }
        Font font = style.getFont();
        int charWidth = font.charWidth(widestChar);
        Style selectedStyle = this.getSelectedStyle();
        if (selectedStyle.getFont() != style.getFont() && (cw = selectedStyle.getFont().charWidth(widestChar)) > charWidth) {
            charWidth = cw;
            font = selectedStyle.getFont();
        }
        style = this.getStyle();
        int tPadding = style.getPadding(false, 3) + style.getPadding(false, 1);
        int textAreaWidth = this.getWidth() - tPadding;
        int minCharactersInRow = Math.max(1, textAreaWidth / charWidth);
        int rowIndex = 0;
        int from = 0;
        int to = from + minCharactersInRow;
        int textLength = text.length;
        if (textLength / minCharactersInRow > Math.max(2, rows)) {
            textAreaWidth -= UIManager.getInstance().getLookAndFeel().getVerticalScrollWidth();
            textAreaWidth -= charWidth / 2;
        }
        String unsupported = this.getUnsupportedChars();
        to = Math.max(Math.min(textLength - 1, to), 0);
        while (to < textLength) {
            int c;
            int i;
            if (to > textLength) {
                to = textLength;
            }
            int spaceIndex = -1;
            String rowText = "";
            int maxLength = to;
            if (useStringWidth) {
                for (i = to; i < textLength && this.fastCharWidthCheck(text, from, i - from + 1, textAreaWidth, charWidth, font) && this.updateRowWidth((char)(c = text[i]), font) < textAreaWidth; ++i) {
                    if (unsupported.indexOf(c) > -1) {
                        text[i] = 32;
                        c = 32;
                    }
                    if (c == 32 || c == 10) {
                        spaceIndex = i;
                        if (c == 10) break;
                    }
                    ++maxLength;
                }
            } else {
                this.currentRowWidth = 0;
                if (to != from) {
                    this.currentRowWidth = font.charsWidth(text, from, to - from);
                }
                for (i = to; i < textLength && this.updateRowWidth((char)(c = text[i]), font) < textAreaWidth; ++i) {
                    if (unsupported.indexOf(c) > -1) {
                        text[i] = 32;
                        c = 32;
                    }
                    if (c == 32 || c == 10) {
                        spaceIndex = i;
                        if (c == 10) break;
                    }
                    ++maxLength;
                }
            }
            if (i == textLength || text[i] == ' ' || text[i] == '\n') {
                spaceIndex = i;
            }
            if (spaceIndex != -1) {
                int newLine = this.indexOf(text, '\n', from, spaceIndex - from);
                if (newLine > -1 && newLine < spaceIndex) {
                    spaceIndex = newLine;
                }
                rowText = new String(text, from, spaceIndex - from);
                from = spaceIndex + 1;
            } else {
                for (i = to; spaceIndex == -1 && i >= from; --i) {
                    char chr = text[i];
                    if (chr != ' ' && chr != '\n' && chr != '\t') continue;
                    spaceIndex = i;
                    int newLine = this.indexOf(text, '\n', from, i - from);
                    if (newLine > -1 && newLine < spaceIndex) {
                        spaceIndex = newLine;
                    }
                    rowText = new String(text, from, spaceIndex - from);
                    from = spaceIndex + 1;
                }
                if (spaceIndex == -1) {
                    if (maxLength <= 0) {
                        maxLength = 1;
                    }
                    spaceIndex = maxLength;
                    rowText = new String(text, from, spaceIndex - from);
                    from = spaceIndex;
                }
            }
            this.rowStrings.addElement(rowText);
            to = from;
            ++rowIndex;
        }
    }

    public int getRowsGap() {
        return this.rowsGap;
    }

    public void setRowsGap(int rowsGap) {
        this.rowsGap = rowsGap;
    }

    public void paint(Graphics g) {
        UIManager.getInstance().getLookAndFeel().drawTextArea(g, this);
    }

    protected Dimension calcPreferredSize() {
        return UIManager.getInstance().getLookAndFeel().getTextAreaSize(this, true);
    }

    protected Dimension calcScrollSize() {
        return UIManager.getInstance().getLookAndFeel().getTextAreaSize(this, false);
    }

    public void addActionListener(ActionListener a) {
        if (this.actionListeners == null) {
            this.actionListeners = new Vector();
        }
        if (!this.actionListeners.contains(a)) {
            this.actionListeners.addElement(a);
        }
    }

    public void removeActionListener(ActionListener a) {
        if (this.actionListeners == null) {
            this.actionListeners = new Vector();
        }
        this.actionListeners.removeElement(a);
    }

    void fireActionEvent() {
        if (this.actionListeners != null) {
            ActionEvent evt = new ActionEvent(this);
            for (int iter = 0; iter < this.actionListeners.size(); ++iter) {
                ActionListener a = (ActionListener)this.actionListeners.elementAt(iter);
                a.actionPerformed(evt);
            }
        }
    }

    void onEditComplete(String text) {
        this.setText(text);
        this.getParent().revalidate();
    }

    public static void setDefaultMaxSize(int value) {
        defaultMaxSize = value;
    }

    public boolean isGrowByContent() {
        return this.growByContent;
    }

    public void setGrowByContent(boolean growByContent) {
        this.growByContent = growByContent;
    }

    public static void setAutoDegradeMaxSize(boolean value) {
        autoDegradeMaxSize = value;
    }

    public static boolean isAutoDegradeMaxSize() {
        return autoDegradeMaxSize;
    }

    public String getUnsupportedChars() {
        return this.unsupportedChars;
    }

    public void setUnsupportedChars(String unsupportedChars) {
        this.unsupportedChars = unsupportedChars;
    }

    public int getLinesToScroll() {
        return this.linesToScroll;
    }

    public void setLinesToScroll(int linesToScroll) {
        if (linesToScroll < 1) {
            throw new IllegalArgumentException("lines to scroll has to be >= 1");
        }
        this.linesToScroll = linesToScroll;
    }

    public static void setWidestChar(char widestC) {
        widestChar = widestC;
    }

    public static char getWidestChar() {
        return widestChar;
    }

    public void setSingleLineTextArea(boolean singleLineTextArea) {
        this.singleLineTextArea = singleLineTextArea;
    }

    public boolean isSingleLineTextArea() {
        return this.singleLineTextArea;
    }

    public void setAlignment(int align) {
        if (align != 4 && align != 3 && align != 1) {
            throw new IllegalArgumentException("Alignment can't be set to " + align);
        }
        this.align = align;
        this.absAlign = align;
        if (this.isRTL()) {
            switch (align) {
                case 1: {
                    this.absAlign = 3;
                    break;
                }
                case 3: {
                    this.absAlign = 1;
                }
            }
        }
    }

    public int getAlignment() {
        return this.align;
    }

    public int getAbsoluteAlignment() {
        return this.absAlign;
    }

    public boolean isPendingCommit() {
        return false;
    }

    public int getCursorPosition() {
        return -1;
    }

    public int getCursorY() {
        return -1;
    }

    public int getCursorX() {
        return -1;
    }

    public boolean isQwertyInput() {
        return false;
    }

    public String getInputMode() {
        return null;
    }

    public String[] getInputModeOrder() {
        return null;
    }

    public boolean isEnableInputScroll() {
        return false;
    }

    protected boolean isEnterKey(int keyCode) {
        return keyCode == 10;
    }

    public static void autoDetectWidestChar(String s) {
        Font f = UIManager.getInstance().getComponentStyle("TextArea").getFont();
        int widest = 0;
        for (int iter = 0; iter < s.length(); ++iter) {
            char c = s.charAt(iter);
            int w = f.charWidth(c);
            if (w <= widest) continue;
            widest = w;
            TextArea.setWidestChar(c);
        }
    }

    public static boolean isUseStringWidth() {
        return useStringWidth;
    }

    public static void setUseStringWidth(boolean aUseStringWidth) {
        useStringWidth = aUseStringWidth;
    }

    static {
        widestChar = (char)87;
    }
}

